!#########################################################################################################################################################
!>
!> myXCLASS
!>  Copyright (C) 2012 - 2024  Thomas Moeller
!>
!>  I. Physikalisches Institut, University of Cologne
!>
!>
!>
!>  "The user is ignorant, stupid and impatient!"
!>
!>
!>
!>  Versions of the program:
!>
!>  Who           When          What
!>
!>  P. Schilke    2009 - 2012   Initial version
!>  T. Moeller    2012-05-30    Updated version
!>
!>
!>
!>  License:
!>
!>    GNU GENERAL PUBLIC LICENSE
!>    Version 3, 29 June 2007
!>    (Copyright (C) 2007 Free Software Foundation, Inc. <http://fsf.org/>)
!>
!>
!>    This program is free software: you can redistribute it and/or modify
!>    it under the terms of the GNU General Public License as published by
!>    the Free Software Foundation, either version 3 of the License, or
!>    (at your option) any later version.
!>
!>    This program is distributed in the hope that it will be useful,
!>    but WITHOUT ANY WARRANTY; without even the implied warranty of
!>    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!>    GNU General Public License for more details.
!>
!>    You should have received a copy of the GNU General Public License
!>    along with this program.  If not, see <http://www.gnu.org/licenses/>.
!>
!#########################################################################################################################################################


program myXCLASS

    use GlobalVariables
    use CommentLineVariables
    use ReadXML
    use omp_lib

    implicit none
    integer :: ok                                                                           !< status variable
    integer :: l                                                                            !< current frequncy range index (here always 1)
    integer :: open_stat                                                                    !< status of open statement
    integer :: NumComp                                                                      !< working variable: total number of comp.
    integer :: TotalNumFreqRan                                                              !< total number of frequency ranges
    integer :: NumDataPoints                                                                !< working variable: total number of freq. points
    integer :: ThreadNumber                                                                 !< working variable: thread number
    integer :: FirstIndex                                                                   !< index for first freq. data point
    integer :: LastIndex                                                                    !< index for last freq. data point
    integer :: LocalNumFreqPoints                                                           !< local number of freq. points
    integer :: ModeID                                                                       !< debug mode
    integer :: allocstatus, deallocstatus                                                   !< variables for (de)allocation
    integer, dimension(8) :: VALUES                                                         !< value for the date_and_time subroutine
    real*8 :: chi2Value                                                                     !< unused dummy argument
    real*8, dimension(1) :: ParameterVector                                                 !< unused dummy argument
    real*8, allocatable, dimension(:) :: ModelFuncList                                      !< unused dummy argument
    logical :: ModelFunctionFlag                                                            !< unused dummy argument
    character(len=8) :: DATE                                                                !< variable for the date_and_time subroutine
    character(len=10) :: TIME                                                               !< variable for the date_and_time subroutine
    character(len=5) :: ZONE                                                                !< variable for the date_and_time subroutine
    character(len=30) :: numberString1                                                      !< working variable: used for integer to string conversion
    character(len=8192) :: EnvironmentVariableValue                                         !< working variable: environment variable


    !<----------------------------------------------------------------------------------------------------------------------------------------------------
    !< initialize variables
    printflag = .true.                                                                      !< define flag for screen output ( = 0: no screen output)
    N_H = 0.d0
    T_back = 0.d0
    T_slope = 0.d0
    beta_dust = 0.d0
    kappa_1300 = 0.d0
    rms_mod = 0.d0
    verbose = .true.
    PeakShape = 1                                                                           !< default shape is Gaussian
    old = .false.
    AllOutputFilesFlag = .false.                                                            !< do not write intensities and optical depths to file
    EmAbsFlag = .false.                                                                     !< write emission and absorption to file
    LogFlag = .true.                                                                        !< write log information to files


    !<----------------------------------------------------------------------------------------------------------------------------------------------------
    !< increase omp stacksize
    EnvironmentVariableValue = ""
    call get_environment_variable("KMP_STACKSIZE", EnvironmentVariableValue)                !< get environment variable
    call getenv("KMP_STACKSIZE", EnvironmentVariableValue)
    EnvironmentVariableValue = trim(adjustl(EnvironmentVariableValue))                      !< remove leading and tailing strings
    if (len_trim(EnvironmentVariableValue) == 0) then
        call get_environment_variable("OMP_STACKSIZE", EnvironmentVariableValue)            !< get environment variable
        call getenv("OMP_STACKSIZE", EnvironmentVariableValue)
        EnvironmentVariableValue = trim(adjustl(EnvironmentVariableValue))                  !< remove leading and tailing strings
        if (len_trim(EnvironmentVariableValue) == 0) then
            call system("export KMP_STACKSIZE='9999M'")
        endif
    endif
    call omp_set_num_threads(NumberProc)                                                    !< set number of threads


    !<----------------------------------------------------------------------------------------------------------------------------------------------------
    !< get variables from the command call
    ok = 0
    call getCommandLineArguments(ok)
    if (ok /= 0) then
        stop
    endif


    !<----------------------------------------------------------------------------------------------------------------------------------------------------
    !< read in xml file containing user parameters
    ok = 0
    call ReadXMLInstanceFile(ok)
    if (ok /= 0) then
        stop
    endif


    !<----------------------------------------------------------------------------------------------------------------------------------------------------
    !< write header of log file including name, date and time
    open(logchannel, file = 'xclass_spectrum.err', status = 'unknown', iostat = open_stat)
    open(2224, file = 'xclass_spectrum.log', status = 'unknown', iostat = open_stat)
    write(2224,'(" ")')
    write(2224,'("myXCLASS log-file for the calculation of the spectrum:")')
    write(2224,'(54("-"))')
    write(2224,'(" ")')


    !<----------------------------------------------------------------------------------------------------------------------------------------------------
    !< get partition function and transition parameters from sqlite3 database
    ParallelizationMethod = "NoMAGIX"
    IntegrationFlag = .true.
    ! IntegrationFlag = .false.
    call myXCLASSInitVar


    !< get current local time and date and write to log-file
    call date_and_time(DATE, TIME, ZONE, VALUES)
    write(2224,'(" ")')
    write(2224,'("Calculation starts at Date: ",A2,".",A2,".",A4,",     Time: ",A2,":",A2,":",A2)') DATE(7:8),DATE(5:6),DATE(1:4), &
                                                                                                    TIME(1:2),TIME(3:4),TIME(5:6)
    write(2224,'(" ")')
    write(2224,'(" ")')
    write(2224, '("Command line arguments:")')
    write(2224, '(2x, "First frequency:              ", ES20.10)') freqmin
    write(2224, '(2x, "Last frequency:               ", ES20.10)') freqmax
    write(2224, '(2x, "Stepsize (resolution):        ", ES20.10)') sim_width
    if (telescope_BMIN /= 0.d0 .and. telescope_BMAJ /= 0.d0) then
        write(2224, '(2x, "BMIN:                         ", ES20.10)') telescope_BMIN
        write(2224, '(2x, "BMAJ:                         ", ES20.10)') telescope_BMAJ
        write(2224, '(2x, "BPA:                          ", ES20.10)') telescope_BPA
    else
        write(2224, '(2x, "Size of telescope:            ", ES20.10)') telescope_size
    endif
    write(2224, '(2x, "Interferrometer flag:             ", L1)') inter_flag
    write(2224, '(2x, "v_LSR:                        ", ES20.10)') LocalvLSR
    if (Redshift /= 0.d0) then
        write(2224, '(2x, "Redshift:                     ", ES20.10)') Redshift
    endif
    write(2224, '(2x, "Background temperature flag:      ", L1)') tback_flag
    write(2224, '(2x, "Background Temperature:       ", ES20.10)') T_back
    write(2224, '(2x, "Temperature Slope:            ", ES20.10)') T_slope
    if (BackgroundFile_Flag) then
        write(2224, '(2x, "Path and name of background file: ", A)') char(34) // trim(adjustl(LocalBackgroundFileName)) // char(34)
    endif
    if (nHFlagCommLine) then
        write(2224, '(2x, "N_H:                          ", ES20.10)') N_H
        write(2224, '(2x, "beta dust:                    ", ES20.10)') beta_dust
        write(2224, '(2x, "kappa:                        ", ES20.10)') kappa_1300
    endif
    if (free_free_flag) then
        write(2224, '(2x, "Te_ff:                        ", ES20.10)') Te_ff
        write(2224, '(2x, "EM_ff:                        ", ES20.10)') EM_ff
    endif
    if (sync_flag) then
        write(2224, '(2x, "kappa_sync:                   ", ES20.10)') kappa_sync
        write(2224, '(2x, "B_sync:                       ", ES20.10)') B_sync
        write(2224, '(2x, "p_sync:                       ", ES20.10)') p_sync
        write(2224, '(2x, "l_sync:                       ", ES20.10)') l_sync
    endif
    if (NumModelPixelXX /= 0 .and. NumModelPixelYY /= 0) then
        write(numberString1, '(I30)') NumModelPixelXX
        write(2224, '(2x, "NumModelPixelXX:                  ", A)') trim(adjustl(numberString1))
        write(numberString1, '(I30)') NumModelPixelYY
        write(2224, '(2x, "NumModelPixelYY:                  ", A)') trim(adjustl(numberString1))
    endif
    write(2224, '(2x, "Local-overlap flag:               ", L1)') FlagLocalOverlap
    write(2224, '(2x, "No sub-beam flag:                 ", L1)') LocalNoSubBeamFlag
    if (EmAbsFlag) then
        write(2224, '(2x, "Em-abs flag:                      ", L1)') EmAbsFlag
    endif
    if (trim(adjustl(LocalEmAbsPATH)) /= "") then
        write(2224, '(2x, "Path of emission/abs. files:      ", A)') char(34) // trim(adjustl(LocalEmAbsPATH)) // char(34)
    endif
    if (DustFile_Flag) then
        write(2224, '(2x, "Path and name of dust file:       ", A)') char(34) // trim(adjustl(LocalDustFileName)) // char(34)
    endif
    write(2224, '(2x, "Path and name of instance file:   ", A)') char(34) // trim(adjustl(InstanceFileName)) // char(34)
    write(2224, '(2x, "Iso flag:                         ", L1)') iso_flag
    write(2224, '(2x, "Path and name of database file:   ", A)') char(34) // trim(adjustl(dbName)) // char(34)
    write(2224,'(" ")')
    write(2224,'(" ")')
    write(2224,'(" ")')
    write(numberString1, '(I30)') TotalNumberDataPoints
    write(2224, '("Number of frequency points of the modelled spectrum = ", A)') trim(adjustl(numberString1))


    !<----------------------------------------------------------------------------------------------------------------------------------------------------
    !< open output file
    open(2222, file = 'xclass_spectrum_output.dat', status = 'unknown', iostat = open_stat)


    !<----------------------------------------------------------------------------------------------------------------------------------------------------
    !< calculate model spectrum (using MAGIX routine)
    ok = 0
    ModelFunctionFlag = .true.
    NumComp = TotalNumberComponents
    TotalNumFreqRan = 1
    chi2Value = 0.d0
    NumDataPoints = lengthexpdata(1)
    ThreadNumber = 0


    !< allocate some variables variable
    if (allocated(ModelFuncList)) then
        deallocate(ModelFuncList, TauCompFileName, IntCompFileName, stat = deallocstatus)
        if (deallocstatus /= 0) then
            stop 'Program aborted!'
        endif
    endif
    allocate(ModelFuncList(NumDataPoints), TauCompFileName(TotalNumberComponents), IntCompFileName(TotalNumberComponents), stat = allocstatus)
    if (allocstatus /= 0) then
        stop 'Program aborted!'
    endif
    ModelFuncList = 0.d0
    TauCompFileName = ""
    IntCompFileName = ""


    !< print what you do
    if (printflag .and. (.not. SubBeamDescriptionFlag)) then
        print '("Calculate spectrum ..", $)'
    endif


    !< determine spectrum
    call ModelCalcSpectrum(NumberFreeParameter, ParameterVector, ModelFunctionFlag, NumComp, chi2Value, CompMoleculeIndex, &
                           myXCLASSParameter, TotalNumberOfMolecules, IsoRatioConversionTable, NumDataPoints, ModelFuncList, ThreadNumber)
    if (ok /= 0) then
        stop
    endif


    !< print what you do
    if (printflag .and. (.not. SubBeamDescriptionFlag)) then
        print '("done!")'
    endif


    !<----------------------------------------------------------------------------------------------------------------------------------------------------
    !< write model cube for sub-beam description to FITS file
    if (SubBeamDescriptionFlag) then
        l = 1                                                                           !< define freq. range index (here 1)
        FirstIndex = DataPointIndexFreqRange(l, 1)                                      !< get index of first freq. point in 'ObservationalDataList'
        LastIndex = DataPointIndexFreqRange(l, 2)                                       !< get index of last freq. point in 'ObservationalDataList'
        LocalNumFreqPoints = LastIndex - FirstIndex + 1                                 !< get number of frequency points
        ModeID = 0
        call WriteModelCube(ModeID, LocalNumFreqPoints, NumberModelPixelXX, NumberModelPixelYY)
        !    ModeID = 1
        !    call WriteModelCube(ModeID, LocalNumFreqPoints, NumberModelPixelXX, NumberModelPixelYY)
    endif


    !<----------------------------------------------------------------------------------------------------------------------------------------------------
    !< close log and output files
    close(2222)
    call date_and_time(DATE, TIME, ZONE, VALUES)
    write(2224, '(" ")')
    write(2224, '(" ")')
    write(2224, '("Calculation ends at Date: ",A2,".",A2,".",A4,",     Time: ",A2,":",A2,":",A2)') DATE(7:8), DATE(5:6), DATE(1:4), &
                                                                                                   TIME(1:2), TIME(3:4), TIME(5:6)
    close(2224)
    close(logchannel, status = 'delete')


    !<----------------------------------------------------------------------------------------------------------------------------------------------------
    !< print a message to the screen
    if (printflag) then
        print '(" ")'
        print '("myXCLASS finished!")'
    endif
end program myXCLASS
