#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# Python script of how to use XCLASS outside CASA
#
# Description:
#
# - this script contains examples of how to set the variables
#   and execute XCLASS outside CASA
#
# - play around with user parameters defined in lines 56 - 104
#
#
# Usage (in the terminal):
#
#   python3 my_mapfit_no-CASA__xml.py
#
#
#  Who                  When            What
#
#  A. Sanchez-Monge     2015-07-01      initial version
#  T. Moeller           2020-02-12      porting to python 3.x
#
#******************************************************************************


#------------------------------------------------------------------------------
# import python packages
import os
#------------------------------------------------------------------------------


##-----------------------------------------------------------------------------
##
## start main program
##
if __name__ == '__main__':


    ## get path of current directory
    LocalPath = os.getcwd() + "/"


    # import XCLASS packages
    from xclass import task_myXCLASSMapFit


    #--------------------------------------------------------------------------
    # Fitting spectra with myXCLASSMapFit task


    ###########################################################################
    # TO MODIFY BY THE USER


    # define path and name of molfit file
    MolfitsFileName = LocalPath + "files/my_map-molecules.molfit"


    # define path and name of obs. data file
    ObsXMLFileName = LocalPath + "files/my_observation__map.xml"


    # define path and name of algorithm xml file
    AlgorithmXMLFileName = LocalPath + "files/my_algorithm-settings.xml"


    ## use fast-fitting method?
    FastFitFlag = True


    ## use full-fitting method?
    FullFitFlag = False


    # define path and name of region file
    regionFileName = LocalPath + "files/my_map-region.reg"


    # define lower limit for intensity (pixel with max. intensity below given
    # limit are ignored)
    Threshold = 0.0


    # define path and name of so-called cluster file
    clusterdef = LocalPath + "files/clusterdef.txt"


    # define number of iterations to smooth parameter maps
    ParamMapIterations = 1


    # define parameter used for smoothing
    ParamSmoothMethodParam = 1.0


    # define scipy method ("gaussian", "uniform", "median") used for parameter
    # map smoothing
    ParamSmoothMethod = "uniform"


    # define path of a directory containing FITS images describing parameter
    # maps to update the parameter defined in the molfit file for each pixel
    ParameterMapDir = ""
    ###########################################################################


    # call myXCLASSMapFit function
    JobDir = task_myXCLASSMapFit.myXCLASSMapFitCore( \
                                MolfitsFileName = MolfitsFileName,
                                ObsXMLFileName = ObsXMLFileName,
                                FastFitFlag = FastFitFlag,
                                FullFitFlag = FullFitFlag,
                                AlgorithmXMLFileName = AlgorithmXMLFileName,
                                clusterdef = clusterdef,
                                regionFileName = regionFileName,
                                Threshold = Threshold,
                                ParameterMapDir = ParameterMapDir,
                                ParamMapIterations = ParamMapIterations,
                                ParamSmoothMethodParam = ParamSmoothMethodParam,
                                ParamSmoothMethod = ParamSmoothMethod)


    # start myXCLASSMapFit GUI
    task_myXCLASSMapFit.StartPlottingGUI(JobDir)


## finished!
##-----------------------------------------------------------------------------
##-----------------------------------------------------------------------------
##-----------------------------------------------------------------------------
