#!/usr/bin/python3
# -*- coding: utf-8 -*-
#
# Python script of how to use XCLASS without CASA
#
# Description:
#
# - this script describes an example of how to set the variables
#   for the myXCLASSFit function
#
# - play around with user parameters defined in lines 91 - 155
#
#
# Usage (in the terminal):
#
#   python3 my_fit_no-CASA__LM.py
#
#
#  Who                  When            What
#
#  A. Sanchez-Monge     2015-07-01      initial version
#  T. Moeller           2020-02-12      porting to python 3.x
#
#******************************************************************************


#------------------------------------------------------------------------------
# import python packages
import os
#------------------------------------------------------------------------------


##-----------------------------------------------------------------------------
##
## start main program
##
if __name__ == '__main__':


    ## get path of current directory
    LocalPath = os.getcwd() + "/"


    # import XCLASS packages
    from xclass import task_myXCLASSFit


    #--------------------------------------------------------------------------
    # Fitting spectra with myXCLASSFit task


    ## initialize input parameters
    MolfitsFileName = ""
    AlgorithmXMLFileName = ""
    NumberIteration = None
    ObsXMLFileName = ""
    ObsDataFileName = ""
    TelescopeSize = None
    BMIN = None
    BMAJ = None
    BPA = None
    Inter_Flag = None
    Redshift = None
    t_back_flag = True
    tBack = None
    tSlope = None
    BackgroundFileName = None
    N_H = None
    beta_dust = None
    kappa_1300 = None
    DustFileName = None
    ContPhenFuncID = None
    ContPhenFuncParam1 = None
    ContPhenFuncParam2 = None
    ContPhenFuncParam3 = None
    ContPhenFuncParam4 = None
    ContPhenFuncParam5 = None
    iso_flag = None
    IsoTableFileName = None
    EmAbsPATH = None
    NumModelPixelXX = None
    NumModelPixelYY = None
    LocalOverlapFlag = False
    NoSubBeamFlag = False
    RestFreq = None
    vLSR = None


    ###########################################################################
    # TO MODIFY BY THE USER


    # define path and name of molfit file
    MolfitsFileName = LocalPath + "files/my_molecules.molfit"


    ## we don't want the result as dictionary
    DictOutFlag = False


    ## set optimizer
    Optimizer = "magix"


    # define path and name of algorithm xml file
    # uncomment the next line will make line 111 superflous
    # AlgorithmXMLFileName = LocalPath + "files/my_algorithm-settings.xml"


    # define max. number of iterations
    NumberIteration = 15


    # define path and name of obs. xml file
    # uncomment the next line will make lines 119 - 154 superflous
    # ObsXMLFileName = LocalPath + "files/my_observation.xml"


    ## set path and name of used obs. data file
    ObsDataFileName = LocalPath + "files/data/observed_spectrum.dat"


    ## define additional parameters


    ## define telescope parameters
    TelescopeSize = 0.38
    Inter_Flag = True
    vLSR = 0.0
    Redshift = 0.0


    ## define continuum parameters
    t_back_flag = True
    tBack = 0.0
    tSlope = 0.0


    ## define dust parameters
    N_H = 1.0E+24
    beta_dust = 0.0
    kappa_1300 = 0.0


    ## define iso ratio parameters
    iso_flag = True
    IsoTableFileName = LocalPath + "files/my_isonames.txt"


    ## define calculation parameters
    NumModelPixelXX = 100
    NumModelPixelYY = 100
    LocalOverlapFlag = False
    NoSubBeamFlag = True
    RestFreq = 0.0
    ###########################################################################


    # call myXCLASSFit function
    newmolfit, modeldata, JobDir = task_myXCLASSFit.myXCLASSFitCore(
                                MolfitsFileName = MolfitsFileName, \
                                ObsXMLFileName = ObsXMLFileName, \
                                ObsDataFileName = ObsDataFileName, \
                                NumberIteration = NumberIteration, \
                                AlgorithmXMLFileName = AlgorithmXMLFileName, \
                                Optimizer = Optimizer, \
                                TelescopeSize = TelescopeSize, BMIN = BMIN,
                                BMAJ = BMAJ, BPA = BPA, Redshift = Redshift, \
                                Inter_Flag = Inter_Flag, \
                                t_back_flag = t_back_flag, tBack = tBack, \
                                tSlope = tSlope, BackgroundFileName = "", \
                                N_H = N_H, beta_dust = beta_dust, \
                                kappa_1300 = kappa_1300, \
                                DustFileName = DustFileName, \
                                ContPhenFuncID = ContPhenFuncID, \
                                ContPhenFuncParam1 = ContPhenFuncParam1, \
                                ContPhenFuncParam2 = ContPhenFuncParam2, \
                                ContPhenFuncParam3 = ContPhenFuncParam3, \
                                ContPhenFuncParam4 = ContPhenFuncParam4, \
                                ContPhenFuncParam5 = ContPhenFuncParam5, \
                                iso_flag = iso_flag, \
                                IsoTableFileName = IsoTableFileName, \
                                EmAbsPATH = EmAbsPATH, \
                                NoSubBeamFlag = NoSubBeamFlag,
                                LocalOverlapFlag = LocalOverlapFlag, \
                                NumModelPixelXX = NumModelPixelXX,
                                NumModelPixelYY = NumModelPixelYY,
                                RestFreq = RestFreq, vLSR = vLSR, \
                                DictOutFlag = DictOutFlag)


## finished!
##-----------------------------------------------------------------------------
##-----------------------------------------------------------------------------
##-----------------------------------------------------------------------------

