#!/usr/bin/python3
# -*- coding: utf-8 -*-
#
# Python script of how to use XCLASS without CASA
#
# Description:
#
# - this script describes an example of how to set the variables
#   for the myXCLASSFit function
#
# - play around with user parameters defined in lines 56 - 73
#
#
# Usage (in the terminal):
#
#   python3 my_fit_no-CASA__Error.py
#
#
#  Who                  When            What
#
#  A. Sanchez-Monge     2015-07-01      initial version
#  T. Moeller           2020-02-12      porting to python 3.x
#
#******************************************************************************


#------------------------------------------------------------------------------
# import python packages
import os
#------------------------------------------------------------------------------


##-----------------------------------------------------------------------------
##
## start main program
##
if __name__ == '__main__':


    ## get path of current directory
    LocalPath = os.getcwd() + "/"


    # import XCLASS packages
    from xclass import task_myXCLASSFit


    #--------------------------------------------------------------------------
    # Fitting spectra with myXCLASSFit task


    ###########################################################################
    # TO MODIFY BY THE USER


    # define path and name of molfit file
    MolfitsFileName = LocalPath + "files/my_molecules.molfit"


    # define path and name of obs. xml file
    ObsXMLFileName = LocalPath + "files/my_observation.xml"


    # define path and name of algorithm xml file
    AlgorithmXMLFileName = LocalPath + "files/my_algorithm-settings__error__MCMC.xml"


    # set optimization package
    Optimizer = "scipy"


    # define if results of myXCLASSFit function are return as dictionary
    DictOutFlag = True
    ###########################################################################


    # call myXCLASSFit function
    OutDict = task_myXCLASSFit.myXCLASSFitCore( \
                                MolfitsFileName = MolfitsFileName, \
                                ObsXMLFileName = ObsXMLFileName, \
                                AlgorithmXMLFileName = AlgorithmXMLFileName, \
                                Optimizer = Optimizer, \
                                DictOutFlag = DictOutFlag)


## finished!
##-----------------------------------------------------------------------------
##-----------------------------------------------------------------------------
##-----------------------------------------------------------------------------

