#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# Python script of how to use XCLASS outside CASA
#
# Description:
#
# - this script contains examples of how to set the variables
#   and execute XCLASS outside CASA
#
# - play around with user parameters defined in lines 57 - 62
#
#
# Usage (in the terminal):
#
#   python3 my_update_no-CASA.py
#
#
#  Who                  When            What
#
#  A. Sanchez-Monge     2015-07-01      initial version
#  T. Moeller           2020-02-12      porting to python 3.x
#
#******************************************************************************


#------------------------------------------------------------------------------
# import python packages
import os
#------------------------------------------------------------------------------


##-----------------------------------------------------------------------------
##
## start main program
##
if __name__ == '__main__':


    ## get path of current directory
    LocalPath = os.getcwd() + "/"


    # import XCLASS packages
    from xclass import task_UpdateDatabase


    #--------------------------------------------------------------------------
    # example to update the database


    ###########################################################################
    # TO MODIFY BY THE USER
    # (comment/uncomment lines defining QueryString variable)


    # EXAMPLE 1: download new database file (all private entries are lost)
    DBUpdateNew = "new"


    # EXAMPLE 2: update entries in existing database file
    # DBUpdateNew = "update"
    ###########################################################################


    # call UpdateDatabase function
    task_UpdateDatabase.UpdateDatabase(DBUpdateNew)


## finished!
##-----------------------------------------------------------------------------
##-----------------------------------------------------------------------------
##-----------------------------------------------------------------------------

