#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# Python script of how to use XCLASS outside CASA
#
# Description:
#
# - this script contains examples of how to set the variables
#   and execute XCLASS outside CASA
#
# - play around with user parameters defined in lines 55 - 68
#
#
# Usage (in the terminal):
#
#   python3 my_load_no-CASA.py
#
#
#  Who                  When            What
#
#  T. Moeller           2020-02-12      initial version
#
#******************************************************************************


#------------------------------------------------------------------------------
# import python packages
import os
#------------------------------------------------------------------------------


##-----------------------------------------------------------------------------
##
## start main program
##
if __name__ == '__main__':


    ## get path of current directory
    LocalPath = os.getcwd() + "/"


    # import XCLASS packages
    from xclass import task_LoadASCIIFile


    #--------------------------------------------------------------------------
    # example to import ASCII file


    ###########################################################################
    # TO MODIFY BY THE USER


    # define path and name of ASCII file
    my_FileName = LocalPath + "files/data/observed_spectrum.dat"


    # define number of header lines
    my_NumHeadLines = 0


    # define rest frequency (in MHz)
    my_rest = 0.0


    # define v_lsr (in km/s)
    my_vlsr = 0.0
    ###########################################################################


    # call LoadASCIIFile function
    FileName = my_FileName
    NumHeaderLines = my_NumHeadLines
    RestFreq = my_rest
    vLSR = my_vlsr
    expdata = task_LoadASCIIFile.LoadASCIIFile(FileName, NumHeaderLines,
                                               RestFreq, vLSR)

## finished!
##-----------------------------------------------------------------------------
##-----------------------------------------------------------------------------
##-----------------------------------------------------------------------------

