#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# Python script of how to use XCLASS outside CASA
#
# Description:
#
# - this script contains examples of how to set the variables
#   and execute XCLASS outside CASA
#
# - play around with user parameters defined in lines 56 - 75
#
#
# Usage (in the terminal):
#
#   python3 my_list_no-CASA.py
#
#
#  Who                  When            What
#
#  A. Sanchez-Monge     2015-07-01      initial version
#  T. Moeller           2020-02-12      porting to python 3
#
#******************************************************************************


#------------------------------------------------------------------------------
# import python packages
import sys
import os
#------------------------------------------------------------------------------


##-----------------------------------------------------------------------------
##
## start main program
##
if __name__ == '__main__':


    ## get path of current directory
    LocalPath = os.getcwd() + "/"


    # import XCLASS packages
    from xclass import task_ListDatabase


    #--------------------------------------------------------------------------
    # example to list entries from the database


    ###########################################################################
    # TO MODIFY BY THE USER

    # define lower limit for transition frequencies (MHz)
    my_minFreq = 210000.0

    # define upper limit for transition frequencies (MHz)
    my_maxFreq = 250000.0

    # define lower limit for E_low (K)
    my_minElow = 0.0

    # define upper limit for E_low (K)
    my_maxElow = 300.0

    # restrict output to molecules defined in this list (if list is empty,
    # print informations to all molecules which have at least one transititons
    # frequency within the given limits)
    my_molecules = ["CO;v=0;", "C-13-O;v=0;"]

    # define path and name of output file (if no path is defined print output
    # to screen)
    OutputDevice = ''
    ###########################################################################


    # call ListDatabase function
    FreqMin = my_minFreq
    FreqMax = my_maxFreq
    ElowMin = my_minElow
    ElowMax = my_maxElow
    SelectMolecule = my_molecules
    Contents = task_ListDatabase.ListDatabase(FreqMin, FreqMax, ElowMin,
                                              ElowMax, SelectMolecule,
                                              OutputDevice)

## finished!
##-----------------------------------------------------------------------------
##-----------------------------------------------------------------------------
##-----------------------------------------------------------------------------

