#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# Python script of how to use XCLASS outside CASA
#
# Description:
#
# - this script contains examples of how to set the variables
#   and execute XCLASS outside CASA
#
# - play around with user parameters defined in lines 56 - 66
#
#
# Usage (in the terminal):
#
#   python3 my_query__no-CASA.py
#
#
#  Who                  When            What
#
#  A. Sanchez-Monge     2015-07-01      initial version
#  T. Moeller           2020-02-12      porting to python 3.x
#
#******************************************************************************


#------------------------------------------------------------------------------
# import python packages
import os
#------------------------------------------------------------------------------


##-----------------------------------------------------------------------------
##
## start main program
##
if __name__ == '__main__':


    ## get path of current directory
    LocalPath = os.getcwd() + "/"


    # import XCLASS packages
    from xclass import task_DatabaseQuery


    #--------------------------------------------------------------------------
    # send SQL query to database


    ###########################################################################
    # TO MODIFY BY THE USER
    # (comment/uncomment lines defining QueryString variable)


    # EXAMPLE 1: get names of all molecules included in the database
    QueryString = "select PF_Name from Partitionfunctions"


    # EXAMPLE 2: get names of all molecules with transition frequencies between
    #            two given frequencies included in the database
    #    FreqMin = 10000.0
    #    FreqMax = 12000.0
    #    QueryString = "select T_Name from transitions where T_Frequency >= "
    #    QueryString += str(FreqMin) + " and T_Frequency <= " + str(FreqMax)
    ###########################################################################


    # call DatabaseQuery function
    Contents = task_DatabaseQuery.DatabaseQuery(QueryString)


## finished!
##-----------------------------------------------------------------------------
##-----------------------------------------------------------------------------
##-----------------------------------------------------------------------------

