#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# Python script of how to use XCLASS outside CASA
#
# Description:
#
# - this script contains examples of how to set the variables
#   and execute XCLASS outside CASA
#
# - play around with user parameters defined in lines 55 - 73
#
#
# Usage (in the terminal):
#
#   python3 my_magix_no-CASA.py
#
#
#  Who                  When            What
#
#  T. Moeller           2020-02-12      initial version
#
#******************************************************************************


#------------------------------------------------------------------------------
# import python packages
import os
import xml.etree.ElementTree as ET
#------------------------------------------------------------------------------


##-----------------------------------------------------------------------------
##
## start main program
##
if __name__ == '__main__':


    ## get path of current directory
    LocalPath = os.getcwd() + "/"


    # import XCLASS packages
    from xclass import task_MAGIX


    #--------------------------------------------------------------------------
    # example of using other parameterized model programs


    ###########################################################################
    # TO MODIFY BY THE USER


    # define path and name of xml file describing data import
    MAGIXExpXML = LocalPath + "files/TwoOscillators_RefFit_R.xml"


    # define path and name of parameter xml file
    MAGIXInstanceXML = LocalPath + "files/parameters.xml"


    # define path and name of algorithm file
    MAGIXFitXML = LocalPath + "files/Levenberg-Marquardt_Parameters.xml"


    # define path and name of registration xml file
    MAGIXRegXML = LocalPath + "files/Conventional_Drude-Lorentz.xml"


    # define MAGIX option
    MAGIXOption = ""
    ###########################################################################


    ## make path of model program absolute
    tree = ET.parse(MAGIXRegXML)
    root = tree.getroot()
    for elem in root.iter('PathStartScript'):
        elem.text = LocalPath + "files/bin/conv-DL.py"
    tree.write(MAGIXRegXML)


    #--------------------------------------------------------------------------
    ## start MAGIX routine
    JobDir = task_MAGIX.MAGIX(MAGIXExpXML, MAGIXInstanceXML, MAGIXFitXML,
                              MAGIXRegXML, MAGIXOption)

## finished!
##-----------------------------------------------------------------------------
##-----------------------------------------------------------------------------
##-----------------------------------------------------------------------------

