#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# Python script of how to use XCLASS outside CASA
#
# Description:
#
# - this script contains examples of how to set the variables
#   and execute XCLASS outside CASA
#
# - play around with user parameters defined in lines 53 - 96
#
#
# Usage (in the terminal):
#
#   python3 my_lineid_no-CASA.py
#
#
#  Who                  When            What
#
#  A. Sanchez-Monge     2015-07-01      initial version
#  T. Moeller           2020-02-12      porting to python 3.x
#
#******************************************************************************


#------------------------------------------------------------------------------
# import python packages
import sys
import os
#------------------------------------------------------------------------------


##-----------------------------------------------------------------------------
##
## start main program
##
if __name__ == '__main__':


    ## get path of current directory
    LocalPath = os.getcwd() + "/"


    # import XCLASS packages
    from xclass import task_LineIdentification


    ###########################################################################
    # TO MODIFY BY THE USER


    # define path and name of default molfit file
    DefaultMolfitFile = LocalPath + "files/my_LineID__default.molfit"


    # define path and name of obs. xml file
    ObsXMLFileName = LocalPath + "files/my_observation__LineID.xml"


    # define list of molecules with are analyzed
    SelectedMolecules = ["HCCCN;v=0;", "CH3OH;v=0;", "C2H5OH;v=0;",
                         "CH3CN;v=0;", "SO;v=0;", "SO2;v=0;"]


    # define upper limit of overestimation
    MaxOverestimationHeight = 500.0


    # define tolerance
    Tolerance = 65.0


    # define path and name of algorithm xml files
    AlgorithmXMLFileSMF = LocalPath + "files/my_algorithm-settings.xml"
    AlgorithmXMLFileOverAll = LocalPath + "files/my_algorithm-settings.xml"


    # define lower limit for column density of core components
    MinColumnDensityEmis = 0.0


    # define lower limit for column density of foreground components
    MinColumnDensityAbs = 0.0


    # define source name
    SourceName = ""


    # define list of so-called strong molecules
    StrongMoleculeList = []


    ## define path and name of cluster file
    clusterdef = ""
    ###########################################################################


    # call LineID function
    IdentifiedLines, JobDir = task_LineIdentification.LineIdentificationCore(
                            MaxOverestimationHeight = MaxOverestimationHeight,
                            SourceName = SourceName,
                            DefaultMolfitFile = DefaultMolfitFile,
                            Tolerance = Tolerance,
                            SelectedMolecules = SelectedMolecules,
                            StrongMoleculeList = StrongMoleculeList,
                            MinColumnDensityEmis = MinColumnDensityEmis,
                            MinColumnDensityAbs = MinColumnDensityAbs,
                            AlgorithmXMLFileSMF = AlgorithmXMLFileSMF,
                            AlgorithmXMLFileOverAll = AlgorithmXMLFileOverAll,
                            experimentalData = ObsXMLFileName,
                            clusterdef = clusterdef)

## finished!
##-----------------------------------------------------------------------------
##-----------------------------------------------------------------------------
##-----------------------------------------------------------------------------

