#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# Python script of how to use XCLASS outside CASA
#
# Description:
#
# - this script contains examples of how to set the variables
#   and execute XCLASS outside CASA
#
# - play around with user parameters defined in lines 130 - 165
#
#
# Usage (in the terminal):
#
#   python3 my_transitions_no-CASA.py
#
#
#  Who                  When            What
#
#  A. Sanchez-Monge     2015-07-01      initial version
#  T. Moeller           2020-02-12      porting to python 3.x
#
#******************************************************************************


#------------------------------------------------------------------------------
# import python packages
import os
#------------------------------------------------------------------------------


##-----------------------------------------------------------------------------
##
## start main program
##
if __name__ == '__main__':


    ## get path of current directory
    LocalPath = os.getcwd() + "/"


    # import XCLASS packages
    from xclass import task_LoadASCIIFile
    from xclass import task_GetTransitions
    from xclass import task_myXCLASS


    #--------------------------------------------------------------------------
    # Creating the synthetic spectra with myXCLASS task


    ## define parameters
    FreqMin = 219764.24
    FreqMax = 221471.74
    FreqStep = 0.1
    TelescopeSize = 0.38
    BMIN = None
    BMAJ = None
    BPA = None
    Inter_Flag = True
    Redshift = None
    t_back_flag = True
    tBack = 0.0
    tslope = 0.0
    BackgroundFileName = ""
    N_H = 1.e24
    beta_dust = 0.0
    kappa_1300 = 0.0
    DustFileName = ""
    ContPhenFuncID = None
    ContPhenFuncParam1 = None
    ContPhenFuncParam2 = None
    ContPhenFuncParam3 = None
    ContPhenFuncParam4 = None
    ContPhenFuncParam5 = None
    MolfitsFileName = LocalPath + "files/my_molecules.molfit"
    iso_flag = True
    IsoTableFileName = LocalPath + "files/my_isonames.txt"
    NumModelPixelXX = 100
    NumModelPixelYY = 100
    LocalOverlapFlag = False
    NoSubBeamFlag = False
    dbFilename = ""
    RestFreq = 0.0
    vLSR = 0.0


    ## call myXCLASS function
    modeldata, log, TransEnergies, IntOpt, JobDir = task_myXCLASS.myXCLASS(
                                                FreqMin, FreqMax, FreqStep,
                                                TelescopeSize, BMIN, BMAJ,
                                                BPA, Inter_Flag, Redshift,
                                                t_back_flag, tBack, tslope,
                                                BackgroundFileName,
                                                N_H, beta_dust, kappa_1300,
                                                DustFileName, ContPhenFuncID,
                                                ContPhenFuncParam1,
                                                ContPhenFuncParam2,
                                                ContPhenFuncParam3,
                                                ContPhenFuncParam4,
                                                ContPhenFuncParam5,
                                                MolfitsFileName, iso_flag,
                                                IsoTableFileName,
                                                NumModelPixelXX,
                                                NumModelPixelYY,
                                                LocalOverlapFlag,
                                                NoSubBeamFlag,
                                                dbFilename,
                                                RestFreq, vLSR)


    #--------------------------------------------------------------------------
    # Loading an ascii file with observed data
    FileName = LocalPath + "files/data/observed_spectrum.dat"
    NumHeaderLines = 0
    expdata = task_LoadASCIIFile.LoadASCIIFile(FileName, NumHeaderLines,
                                               RestFreq, vLSR)


    #--------------------------------------------------------------------------
    # example of an interactive selection of a frequency range


    ###########################################################################
    # TO MODIFY BY THE USER

    # define array containting obs. data
    expdata = expdata

    # define array containting synthetic spectrum
    modeldata = modeldata

    # define lower limit for transition frequencies (MHz)
    FreqMin = 0.0

    # define upper limit for transition frequencies (MHz)
    FreqMax = 1.e8

    # define lower limit for E_low (K)
    ElowMin = 0.0

    # define upper limit for E_low (K)
    ElowMax = 100.0

    # restrict output to molecules defined in this list (if list is empty,
    # print informations to all molecules which have at least one transititons
    # frequency within the given limits)
    SelectMolecule = []

    # define half width of frequency range (MHz) whose central frequency is
    # selected within the GUI
    FrequencyWidth = 20.0
    ###########################################################################


    # call GetTransitions function
    task_GetTransitions.GetTransitions(expdata, FreqMin, FreqMax,
                                       SelectMolecule, FrequencyWidth,
                                       ElowMin, ElowMax, modeldata)


## finished!
##-----------------------------------------------------------------------------
##-----------------------------------------------------------------------------
##-----------------------------------------------------------------------------

