Modeling astronomical data is essential to derive physical parameters such as
column densities and rotational temperatures, as well as information on the
location and the kinematics of the emitting gas component for each observed
molecular species.

The toolbox offers not only the possibility to model data by using the
myXCLASS program (Schilke et al. 2001; Comito et al. 2005;
Zernickel et al. 2012; Crockett et al. 2014a,b; Neill et al. 2014), which
computes synthetic spectra by solving the detection equation similar to
software packages like Weeds (Maret et al. 2011) and CASSIS
[http://cassis.irap.omp.eu/], but also makes use of the optimization
package MAGIX (Möller et al. 2013). MAGIX provides a framework of an easy
interface between existing codes and an iterating engine that attempts to
minimize deviations of the model results from available observational data,
constraining the values of the model parameters and providing corresponding
error estimates. In addition to the myXCLASS program many external model
programs (Here, the phrase "external model program" means the external
program that calculates the model function depending on several input
parameters.) such as RADEX (Van der Tak et al. 2007), RADMC-3D
[http://www.ita.uni-heidelberg.de/~dullemond/software/radmc-3d/] or LIME
(Brinch & Hogerheijde 2010) can be plugged into MAGIX to explore their
parameter space and find the set of parameter values that best fits
observational data. Most of the optimization algorithms included in the
MAGIX package are available as an OpenMP [http://openmp.org/wp/] and an
MPI [http://www.open-mpi.org/] version to speed up the computation.
Furthermore, the toolbox includes two new functions which provide a
simplified interface for MAGIX in conjunction with myXCLASS to model
single spectra and complete data cubes, respectively.

The Splatalogue database [http://www.splatalogue.net] is accessible from
within the viewer in CASA. We have opted to use our own SQLite3 database
based on the VAMDC [http://www.vamdc.eu] implementation, mostly because
this allows the user to augment the data by providing the partition function
between 1.072 and 1000 K at 110 different temperatures in contrast to seven
temperatures in the Splatalogue database, which is derived from the
traditional JPL [http://spec.jpl.nasa.gov] and CDMS [http://www.cdms.de]
catalogs. It is hoped that the content of Splatalogue and the VAMDC database
will at some point be homogenized.

The XCLASS interface for CASA is mostly written in python, whereas the
myXCLASS program and most of the algorithms included in the MAGIX package
are written in Fortran 90.


Credits

This package is developed by:

    Thomas Möller (moeller@ph1.uni-koeln.de)

Original development included substantial contributions from: - Peter Schilke (schilke@ph1.uni-koeln.de)