#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# Tutorial: myXCLASSMapFit
#
# Description:
#
# - call ``myXCLASSMapFit`` function
#
#
# Usage (in the terminal):
#
#   python3 start_MapFit.py
#
#
#  Who                  When            What
#
#  T. Moeller           2023-10-26      initial version
#
#******************************************************************************


#------------------------------------------------------------------------------
from xclass import task_myXCLASSMapFit
import os
#------------------------------------------------------------------------------


##-----------------------------------------------------------------------------
##
## start main program
##
if __name__ == '__main__':


    ## get path of current directory
    LocalPath = os.getcwd() + "/"


    # define path and name of molfit file
    MolfitsFileName = LocalPath + "files/tutorial-mapfit__Band_6.molfit"


    # define path and name of obs. data file
    ObsXMLFileName = LocalPath + "files/tutorial-mapfit__obs__Band_6.xml"


    # define path and name of algorithm xml file
    AlgorithmXMLFileName = LocalPath + "files/tutorial-mapfit__algorithm.xml"


    ## use fast-fitting method?
    FastFitFlag = True


    ## use full-fitting method?
    FullFitFlag = False


    # define path and name of region file
    regionFileName = LocalPath + "files/tutorial-mapfit__region__Band_6.reg"


    # define lower limit for intensity (pixel with max. intensity below given
    # limit are ignored)
    Threshold = 0.0


    # define number of iterations to smooth parameter maps
    ParamMapIterations = 2


    # define parameter used for smoothing
    ParamSmoothMethodParam = 6.0


    # define scipy method ("gaussian", "uniform", "median") used for parameter
    # map smoothing
    ParamSmoothMethod = "uniform"


    # define path of a directory containing FITS images describing parameter
    # maps to update the parameter defined in the molfit file for each pixel
    ParameterMapDir = ""


    # call myXCLASSMapFit function
    JobDir = task_myXCLASSMapFit.myXCLASSMapFitCore( \
                            MolfitsFileName = MolfitsFileName, \
                            ObsXMLFileName = ObsXMLFileName, \
                            FastFitFlag = FastFitFlag, \
                            FullFitFlag = FullFitFlag, \
                            AlgorithmXMLFileName = AlgorithmXMLFileName, \
                            regionFileName = regionFileName, \
                            Threshold = Threshold, \
                            ParameterMapDir = ParameterMapDir, \
                            ParamMapIterations = ParamMapIterations, \
                            ParamSmoothMethodParam = ParamSmoothMethodParam, \
                            ParamSmoothMethod = ParamSmoothMethod)


    # start myXCLASSMapFit GUI
    task_myXCLASSMapFit.StartPlottingGUI(JobDir)


## finished!
##-----------------------------------------------------------------------------
##-----------------------------------------------------------------------------
##-----------------------------------------------------------------------------
