#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# Tutorial: myXCLASSMapFit
#
# Description:
#
# - we used the ``GetTransition`` function to identify the molecules
#   included in the selected spectrum.
#
#
# Usage (in the terminal):
#
#   python3 start_GetTransitions.py
#
#
#  Who                  When            What
#
#  T. Moeller           2023-10-26      initial version
#
#******************************************************************************


#------------------------------------------------------------------------------
from xclass import task_GetTransitions
from astropy import units as u
from spectral_cube import SpectralCube
import numpy as np
#------------------------------------------------------------------------------


##-----------------------------------------------------------------------------
##
## start main program
##
if __name__ == '__main__':


    # get min. and max. frequency from FITS data cube directly
    ObsDataFileName = "files/data/I16293_220GHzcorrected.ms.selfcube.image.fits"
    cube = SpectralCube.read(ObsDataFileName)
    cube2 = cube.with_spectral_unit(u.MHz)


    # get spectrum at the central position
    # the order of the dimensions is always (n_spectral, n_y, n_x)
    nu, dec, ra = cube2.world[:]
    pos_ra = int(len(ra[0, 0, :]) / 2)
    pos_dec = int(len(dec[0, :, 0]) / 2)
    obsdata = cube2[:, pos_ra, pos_dec].value
    obsdata = np.vstack((nu[:, 0, 0].value, obsdata)).T

    # Debug:
    # print ("obsdata = ", obsdata)


    # define other input parameters for GetTransitions function
    SelectMolecule = []
    ElowMin = 0.0
    ElowMax = 3000.0


    # call GetTransitions function
    task_GetTransitions.GetTransitionsCore(obsdata = obsdata, \
                                           SelectMolecule = SelectMolecule, \
                                           ElowMin = ElowMin, \
                                           ElowMax = ElowMax)


## finished!
##-----------------------------------------------------------------------------
##-----------------------------------------------------------------------------
##-----------------------------------------------------------------------------
