#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# Python script of how to use XCLASS outside CASA
#
# Description:
#
# - this script describes an example of how to identify
#   species in a given spectrum using the LineID function
#
#
# Usage (in the terminal):
#
#   python3 my_lineid_no-CASA.py
#
#
#  Who                  When            What
#
#  T. Moeller           2023-10-27      initial version
#
#******************************************************************************


#------------------------------------------------------------------------------
# import python packages
import sys
import os
#------------------------------------------------------------------------------


##-----------------------------------------------------------------------------
##
## start main program
##
if __name__ == '__main__':


    ## get path of current directory
    LocalPath = os.getcwd() + "/"


    # import XCLASS packages
    from xclass import task_LineIdentification


    ###########################################################################
    # TO MODIFY BY THE USER


    # define path and name of default molfit file
    DefaultMolfitFile = LocalPath + "files/tutorial-lineid__default.molfit"


    # define path and name of obs. xml file
    ObsXMLFileName = LocalPath + "files/tutorial-lineid__obs.xml"


    # define list of molecules with are analyzed
    SelectedMolecules = ["CH3OCHO;v=0;", "CH3CHO;v=0;", "CH3OH;v=0;",
                         "CH3CN;v=0;", "SO2;v=0;"]


    # define upper limit of overestimation
    MaxOverestimationHeight = 500.0


    # define tolerance
    Tolerance = 80.0


    # define path and name of algorithm xml files
    AlgorithmXMLFileSMF = LocalPath + "files/tutorial-lineid__algorithm.xml"
    AlgorithmXMLFileOverAll = LocalPath + "files/tutorial-lineid__algorithm.xml"


    # define lower limit for column density of core components
    MinColumnDensityEmis = 0.0


    # define lower limit for column density of foreground components
    MinColumnDensityAbs = 0.0


    # define source name
    SourceName = ""


    # define list of so-called strong molecules
    StrongMoleculeList = []


    ## define path and name of cluster file
    clusterdef = ""
    ###########################################################################


    # call LineID function
    IdentifiedLines, JobDir = task_LineIdentification.LineIdentificationCore(
                            MaxOverestimationHeight = MaxOverestimationHeight,
                            SourceName = SourceName,
                            DefaultMolfitFile = DefaultMolfitFile,
                            Tolerance = Tolerance,
                            SelectedMolecules = SelectedMolecules,
                            StrongMoleculeList = StrongMoleculeList,
                            MinColumnDensityEmis = MinColumnDensityEmis,
                            MinColumnDensityAbs = MinColumnDensityAbs,
                            AlgorithmXMLFileSMF = AlgorithmXMLFileSMF,
                            AlgorithmXMLFileOverAll = AlgorithmXMLFileOverAll,
                            experimentalData = ObsXMLFileName,
                            clusterdef = clusterdef)

## finished!
##-----------------------------------------------------------------------------
##-----------------------------------------------------------------------------
##-----------------------------------------------------------------------------

