#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# Python script of how to use XCLASS without CASA
#
# Description:
#
# - this script describes an example of how to estimate the errors
#   of the model parameters using the myXCLASSFit function
#
#
# Usage (in the terminal):
#
#   python3 XCLASS-tutorial___start_Error-Estimation.py
#
#
#  Who                  When            What
#
#  T. Moeller           2023-10-27      initial version
#
#******************************************************************************


#------------------------------------------------------------------------------
# import python packages
import os
#------------------------------------------------------------------------------


##-----------------------------------------------------------------------------
##
## start main program
##
if __name__ == '__main__':


    ## get path of current directory
    LocalPath = os.getcwd() + "/"


    # import XCLASS packages
    from xclass import task_myXCLASSFit


    #--------------------------------------------------------------------------
    # Fitting spectra with myXCLASSFit task


    ###########################################################################
    # TO MODIFY BY THE USER


    # define path and name of molfit file
    MolfitsFileName = LocalPath + "files/tutorial-error__molecules.molfit"


    # define path and name of obs. xml file
    ObsXMLFileName = LocalPath + "files/tutorial-error__obs.xml"


    # define path and name of algorithm xml file
    AlgorithmXMLFileName = LocalPath + "files/tutorial-error__algorithm.xml"


    # set optimization package
    Optimizer = "scipy"


    # define if results of myXCLASSFit function are return as dictionary
    DictOutFlag = True
    ###########################################################################


    # call myXCLASSFit function
    OutputDictionary = task_myXCLASSFit.myXCLASSFitCore( \
                                MolfitsFileName = MolfitsFileName, \
                                AlgorithmXMLFileName = AlgorithmXMLFileName, \
                                ObsXMLFileName = ObsXMLFileName, \
                                Optimizer = Optimizer, \
                                DictOutFlag = DictOutFlag)


## finished!
##-----------------------------------------------------------------------------
##-----------------------------------------------------------------------------
##-----------------------------------------------------------------------------
